﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HugsLib;
using RimWorld;
using Verse;
using UnityEngine;
using System.Reflection;
using Harmony;

namespace DeepResourceTextMod
{

    // IntVec3 intVec = UI.MouseCell();
    //Find.VisibleMap.deepResourceGrid.ThingDefAt(intVec);

    public class SeeDeepOre : ModBase
    {
        private bool isWorldLoaded = false;

        GameObject myWantDrawHolder;
        HoldBoolScript holdBool;

        bool setThisFrame = false;

        public override string ModIdentifier
        {
            get { return "feffeseedeeporeidentity"; }
        }

        public override void WorldLoaded()
        {
            isWorldLoaded = true;

            var boolHolder = GameObject.Find("FeffeBoolHolder");
            if (!boolHolder)
            {
                myWantDrawHolder = new GameObject("FeffeBoolHolder");
                myWantDrawHolder.AddComponent<HoldBoolScript>();
            }
            else
                myWantDrawHolder = boolHolder;

            holdBool = myWantDrawHolder.GetComponent<HoldBoolScript>();


            base.WorldLoaded();
        }


        public override void OnGUI()
        {
            base.OnGUI();

            if (!myWantDrawHolder)
                return;

            Logger.Message(holdBool.WantDraw.ToString());


            if (isWorldLoaded && holdBool.WantDraw)
            {

                IntVec3 intVec = UI.MouseCell();

                var ore = Find.VisibleMap.deepResourceGrid.ThingDefAt(intVec);
                if (ore != null)
                {
                    GUI.Label(new Rect(UI.MousePositionOnUIInverted + new Vector2(10, -20), new Vector2(100, 20)), ore.defName);
                }

                if (!setThisFrame)
                    setThisFrame = true;
                else
                {
                    setThisFrame = false;
                    holdBool.WantDraw = false;
                }

            }
        }
    }

    public class HoldBoolScript : MonoBehaviour
    {
        public bool WantDraw = false;
    }

    [HarmonyPatch(typeof(DeepResourceGrid), "MarkForDraw")]
    public static class DeepResourcesGrid_Draw_Patch
    {
        [HarmonyPrefix]
        public static void AddSomething(/*DeepResourceGrid __instance*/)
        {
            var go = GameObject.Find("FeffeBoolHolder");
            go.GetComponent<HoldBoolScript>().WantDraw = true;
        }
    }
}
